VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cShapeAlphaImage"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private WithEvents TopLeft As cControlPoint
Attribute TopLeft.VB_VarHelpID = -1
Private WithEvents BottomDown As cControlPoint
Attribute BottomDown.VB_VarHelpID = -1
Private WithEvents CenterDrag As cControlPoint
Attribute CenterDrag.VB_VarHelpID = -1

Public Sub Init(Controlpoints As cControlPoints, ByVal X As Double, ByVal Y As Double, ByVal Width As Double, ByVal Height As Double, ImageFile As String)
  Set TopLeft = Controlpoints.Add("TopLeft" & ObjPtr(Me), X, Y, vbGreen, 6)
  Set BottomDown = Controlpoints.Add("BottomDown" & ObjPtr(Me), X + Width, Y + Height, vbGreen, 6)
  Set CenterDrag = Controlpoints.Add("CenterDrag" & ObjPtr(Me), X + Width / 2, Y + Height / 2, vbMagenta, 9)
  
  'we reuse much of the code of the rectangle-Shape-Class here, so the above three lines are the same (as well as the ControlPoint-Eventhandling)
  
  'and here we add an Image in a reduced size to Cairos central cCairo.ImageList
  'the original Imagesize of our Demo-File 'RedbrushAlpha.jpg' is 1024x960 - but
  'just for demonstration-purposes we show, how to load and store that image in our
  'Cairo.ImageList somewhat smaller (200x200), to safe some memory - becaue we
  'expect, that this image-resource is not scaled by your dynamic "ControlPoint-interaction"
  'much larger than that. ;-) But of course other pre-reduced sizes as e.g. 640x480 would
  'be possible as well - so this prereducing is your own decision (you could of course
  'also store an resource-image in its original size within the Cairo.ImageList
  Cairo.ImageList.AddImage "AlphaImageKey", ImageFile, 200, 200, True '<- note the last Param, ...
  '...which has now centered the image in the 200x200 Imagelist-Buffer, whilst keeping its aspect ratio
End Sub

Public Sub Draw(CC As cCairoContext)
  CC.Save
    'pretty simple the drawing in this case, since it is only one call
    'the last param ensures correctly centered aspect-ratio-drawing in our dynamic resizing here as well
    'and since the image already contains an Alpha-Channel, we let the Opacity with 90% somewhat higher
    CC.RenderSurfaceContent "AlphaImageKey", TopLeft.X, TopLeft.Y, Width, Height, , 0.9, True
  CC.Restore
End Sub

Public Property Get Width() As Double
  Width = BottomDown.X - TopLeft.X
End Property
Public Property Get Height() As Double
  Height = BottomDown.Y - TopLeft.Y
End Property


'Control-Point Movement-Events are received below, and we will act accordingly with the necessary adaptions

Private Sub TopLeft_PositionChanging(NewX As Double, NewY As Double)
  If BottomDown.X - NewX < 30 Then NewX = BottomDown.X - 30 'we restrict the Width to a minimum of 30 pixels
  If BottomDown.Y - NewY < 30 Then NewY = BottomDown.Y - 30 'and the Height too...
  
  CenterDrag.X = NewX + Width / 2 '...and readjust the centerPoint accordingly as well
  CenterDrag.Y = NewY + Height / 2
End Sub
Private Sub BottomDown_PositionChanging(NewX As Double, NewY As Double)
  If NewX - TopLeft.X < 30 Then NewX = TopLeft.X + 30 'we restrict the Width to a minimum of 30 pixels
  If NewY - TopLeft.Y < 30 Then NewY = TopLeft.Y + 30 'and the Height too...
  
  CenterDrag.X = NewX - Width / 2 '...and readjust the centerPoint accordingly as well
  CenterDrag.Y = NewY - Height / 2
End Sub
Private Sub CenterDrag_PositionChanging(NewX As Double, NewY As Double)
Dim W#, H#
  W = Width: H = Height 'we need to buffer the current width and height beforehand, to not mess-up the coord-adaptions below, since Width- and Height are dynamically calculated in Properties
  
  TopLeft.X = NewX - W / 2
  TopLeft.Y = NewY - H / 2
  
  BottomDown.X = NewX + W / 2
  BottomDown.Y = NewY + H / 2
End Sub
